﻿using Microsoft.Web.Http;
using PpmsDataService.Models;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class VaProviderRelationshipsController : ODataController
    {
        [ODataRoute("VaProviderRelationships('{key}')")]
        public async Task<HttpResponseMessage> Get(string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                
                //Retrieve the VA Provider Relationship
                var ppmsVaProviderRelationship = context.ppms_vaproviderrelationshipSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsVaProviderRelationship != null)
                {
                    var ppmsVaProviderRelationshipList = new List<ppms_vaproviderrelationship> { ppmsVaProviderRelationship };
                    var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipList, queryType, context);
                    return Request.CreateResponse(vaProviderRelationships);
                }
            }
            var message = string.Format("VA Provider Relationship with Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }
   
        [ODataRoute("VaProviderRelationships('{key}')/AgreementProviders")]
        public async Task<HttpResponseMessage> GetFacilties([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the VA Provider Relationship
                var ppmsVaProviderRelationship = context.ppms_vaproviderrelationshipSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsVaProviderRelationship != null)
                {
                    var ppmsAgreementProviders =
                        context.ppms_agreementproviderSet.Where(i => i.ppms_VAProviderRelationshipId.Id == ppmsVaProviderRelationship.Id);
                    var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                    var agreementProviders =
                        await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None", context);
                    return Request.CreateResponse(agreementProviders);
                }
            }
            var message = string.Format("No Agreement Providers found for VA Provider Relatonship with Name: {0}", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        [ODataRoute("VaProviderRelationships('{key}')/ProviderServices")]
        public async Task<HttpResponseMessage> GetCareSites([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the VA Provider Relationship
                var ppmsVaProviderRelationship = context.ppms_vaproviderrelationshipSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsVaProviderRelationship != null)
                {
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_VAProviderRelationshipId.Id == ppmsVaProviderRelationship.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("No Provider Services for VA Provider Relationship with Name: {0}", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        [ODataRoute("VaProviderRelationships")]
        public async Task<HttpResponseMessage> Get()
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet
                    .Where(i => i.ppms_name != null).Take(50);
                var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                if (ppmsVaProviderRelationshipsList.Any())
                {
                    var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, queryType, context);
                    return Request.CreateResponse(vaProviderRelationships);
                }
            }
            var message = string.Format("Va Provider Relationships Not Found");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }


    }
}